/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl.http.netty;

import com.floragunn.searchguard.ssl.SearchGuardKeyStore;
import com.floragunn.searchguard.ssl.SslExceptionHandler;
import com.floragunn.searchguard.ssl.http.netty.ValidatingDispatcher;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.ssl.SslHandler;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.HttpHandlingSettings;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.http.netty4.Netty4HttpServerTransport;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.SharedGroupFactory;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class SearchGuardSSLNettyHttpServerTransport
extends Netty4HttpServerTransport {
    private static final Logger logger = LogManager.getLogger(SearchGuardSSLNettyHttpServerTransport.class);
    private final SearchGuardKeyStore sgks;
    private final SslExceptionHandler errorHandler;

    public SearchGuardSSLNettyHttpServerTransport(Settings settings, NetworkService networkService, BigArrays bigArrays, ThreadPool threadPool, SearchGuardKeyStore sgks, NamedXContentRegistry namedXContentRegistry, ValidatingDispatcher dispatcher, ClusterSettings clusterSettings, SharedGroupFactory sharedGroupFactory, SslExceptionHandler errorHandler) {
        super(settings, networkService, bigArrays, threadPool, namedXContentRegistry, (HttpServerTransport.Dispatcher)dispatcher, clusterSettings, sharedGroupFactory, null);
        this.sgks = sgks;
        this.errorHandler = errorHandler;
    }

    protected void populatePerRequestThreadContext(RestRequest restRequest, ThreadContext threadContext) {
        for (String headerName : restRequest.getHeaders().keySet()) {
            List headerValues = (List)restRequest.getHeaders().get(headerName);
            if (headerValues == null || headerValues.isEmpty()) continue;
            threadContext.putHeader(headerName, String.join((CharSequence)",", headerValues));
        }
    }

    public ChannelHandler configureServerChannelHandler() {
        return new SSLHttpChannelHandler(this, this.handlingSettings, this.sgks);
    }

    public void onException(HttpChannel channel, Exception cause0) {
        Throwable cause = cause0;
        if (cause0 instanceof DecoderException && cause0 != null) {
            cause = cause0.getCause();
        }
        this.errorHandler.logError(cause, true);
        if (logger.isDebugEnabled()) {
            logger.debug("Exception during establishing a SSL connection: " + cause, cause);
        }
        super.onException(channel, cause0);
    }

    protected class SSLHttpChannelHandler
    extends Netty4HttpServerTransport.HttpChannelHandler {
        protected SSLHttpChannelHandler(Netty4HttpServerTransport transport, HttpHandlingSettings handlingSettings, SearchGuardKeyStore sgks) {
            super(transport, handlingSettings, null);
        }

        protected void initChannel(Channel ch) throws Exception {
            super.initChannel(ch);
            SslHandler sslHandler = new SslHandler(SearchGuardSSLNettyHttpServerTransport.this.sgks.createHTTPSSLEngine());
            ch.pipeline().addFirst("ssl_http", (ChannelHandler)sslHandler);
        }
    }
}

